#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Aastal - Nothing is less dubMod01.fsh   by  z0rg
//https://www.shadertoy.com/view/3tcyzl
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 3.0
// Unported License. To view a copy of this license, visit http://creativecommons.org/licenses/by-nc-sa/3.0/ 
// or send a letter to Creative Commons, PO Box 1866, Mountain View, CA 94042, USA.
// =========================================================================================================

// A clip I did for a friend
// The video is here https://youtu.be/Fq8qgzzm_nA

#define sat(a) clamp(a, 0., 1.)
mat2 r2d(float a) { float c = cos(a), s = sin(a); return mat2(c, -s, s, c);}
#define FFT(v) (pow(texelFetch(iChannel1, ivec2(v,0),0).x,3.)+.3)

float lenny(vec2 v)
{
    return abs(v.x)+abs(v.y);
}

float _cir(vec2 p, float r)
{
    return length(p)-r;
}
float _rho(vec2 p, float r)
{
    return lenny(p)-r;
}

float _sqr(vec2 p, vec2 s)
{
    vec2 l = abs(p)-s;
    return max(l.x, l.y);
}
vec3 rdr(vec2 uv)
{
    float shp = iResolution.x*.5;
    vec3 col;
    mat2 rotCover = r2d((FFT(10)-.5)*.2);
    vec2 moveScene = rotCover*vec2(FFT(10)-.5, FFT(20)-.5);
    
    // Back
    col = vec3(52, 49, 54)/255.;
    col += .5*(1.-sat(_cir(uv-vec2(.1,0.), .1)*2.))*(vec3(129, 80, 161)/255.);
    col += .5*(1.-sat(_cir(uv-vec2(-.1,0.), .05)*2.))*(vec3(129, 80, 161)/255.).xzy;
    col = pow(col, vec3(2.45));
    
    // back grid
    uv -= .02*moveScene;
    float gridAStp = .1;
    float gridATh = 0.0001;
    
    vec2 gridAv = mod(uv, gridAStp)-gridATh;
    float gridA = min(gridAv.x, gridAv.y);
    col = mix(col, sat(col+vec3(.05)), 1.-sat(gridA*shp));
    
    float gridBStp = gridAStp/5.;
    float gridBTh = gridATh/2.;
    
    vec2 gridBv = mod(uv, gridBStp)-gridBTh;
    float gridB = min(gridBv.x, gridBv.y);
    col = mix(col, sat(col+vec3(.015)), 1.-sat(gridB*shp));
    col *= pow((1.-sat(lenny(uv*.5)-.2)), 5.);
    

    
    // Piou Piou
    
    float barRep = .025;
    float barTh = 0.002;
    
    vec2 uvBars = uv;
    float barsIdx = round((uvBars.y+barRep*.5) / barRep);
    uvBars.y = mod(uvBars.y+.5*barRep, barRep)-barRep;
    
    float bars = _sqr(uvBars, vec2(FFT(5.*(barsIdx+10.))*.5, barTh));
    
    vec3 grad = 0.5 + 0.5*cos(iTime+uv.xyx+vec3(0,2,4)+2.*FFT(barsIdx+10.));
    col += grad *(1.-sat(bars*shp));
    col += grad *(1.-sat(bars*5.))*.5;
    
    // Logo
    vec2 coverUv = moveScene*.25+((cos(iTime*.25)*.2+1.)*5.*uv+vec2(.5));//+vec2(sin(iTime), cos(iTime))*.1;
    //coverUv *= ;
    vec4 coverBlack4 = texture(iChannel0, coverUv*.95);
    vec4 cover4 = texture(iChannel0, coverUv);
    vec3 cover = cover4.xyz;
    col = col*sat(.0+pow(sat(_rho(coverUv-vec2(.5)-vec2(0.,-.1), .5)*2.), .4));
    //col *= sat(.5+1.-coverBlack4.w);
    if (coverUv.x > 0. && coverUv.y > 0. && coverUv.x < 1. && coverUv.y < 1.)
        ;//col = mix(col, cover, cover4.w); // I use the extension to put a custom texture here
//        col = cover;
        

    vec3 rhoCol = 0.5 + 0.5*cos(iTime+uv.xyx+vec3(0,2,4)).zxy;
    
    
    // Border
    float th = .23;
    float border = abs(uv.y)-th;
    
    col = mix(col, vec3(0.), sat(border*shp));
    
    col *= .5+rhoCol*pow(1.-sat(_rho(coverUv-vec2(.5), 1.5)*1.), 1.);

    return col;
}

vec3 chroma(vec2 uv)
{
    vec2 dir = normalize(vec2(1.));
    float strength = 0.025*sat(length(uv))+FFT(10)*.05*length(uv);
    vec3 rgb;
    
    rgb.x = rdr(uv+dir*strength).x;
    rgb.y = rdr(uv).y;
    rgb.z = rdr(uv-dir*strength).z;
    
    return rgb;
}

vec3 cheapAA(vec2 uv)
{
    vec3 col = chroma(uv);
    vec2 off = vec2(1., -1.)/(iResolution.x*2.);
    float diff = pow(fwidth(col.z), 1.);
    if (true)//diff > 0.3) // Not so cheap antialiasing
    {
        //col = vec3(1.,0.,0.);
        vec3 acc = col;
        acc += rdr(uv+off.xx);
        acc += rdr(uv+off.xy);
        acc += rdr(uv+off.yy);
        acc += rdr(uv+off.yx);
        col = acc/5.;
        
    }
    return col;
}


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) {
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = (fragCoord-vec2(.5)*iResolution.xy)/iResolution.xx;

    uv.y *= 1.+abs(uv.x);
    vec3 col = cheapAA(uv);
    
    col = mix(col, col.zxy*(2.-sat(length(uv*4.))), sin(iTime*.5)*.5+.5);

    
    col *= sat(iTime-0.2);
    col *= 1.-sat(iTime-213.);

    fragColor = vec4(col,1.0);
////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

